{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Wirtualna Polska Media S.A.
* @copyright 2021-2022 Wirtualna Polska Media S.A.
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<script>
    {literal}
    var wph_product_obj = {};
    var wph_product_sizes = [];
    var wph_product_colour = [];
    {/literal}

    {foreach from=$product_sizes item=product_one_size}
        {literal}
        var temp_size = '{/literal}{$product_one_size|escape:"javascript":'UTF-8'}{literal}';

        wph_product_sizes.push(temp_size);
        {/literal}
    {/foreach}

    {foreach from=$product_colors item=product_one_color}
        {literal}
        var temp_color = '{/literal}{$product_one_color|escape:"javascript":'UTF-8'}{literal}';

        wph_product_colour.push(temp_color);
        {/literal}
    {/foreach}


    wph_product_obj.id = '{$product_id|escape:"javascript":"UTF-8"}';
    wph_product_obj.name = '{$product_name|escape:"javascript":"UTF-8"}';
    wph_product_obj.category = '{$product_category|escape:"javascript":"UTF-8"}';
    {if !empty($product_ean)}
    wph_product_obj.ean = '{$product_ean|escape:"javascript":"UTF-8"}';
    {/if}
    wph_product_obj.price = {$product_price|escape:"javascript":"UTF-8"};
    wph_product_obj.quantity = {$product_quantity|escape:"javascript":"UTF-8"};
    wph_product_obj.in_stock = {$product_in_stock|escape:"javascript":"UTF-8"};

    wph_product_obj.sizes = wph_product_sizes;
    wph_product_obj.colours = wph_product_colour;


    {literal}
    wph('track', 'ViewContent', {
        content_type: 'Site',
        content_name: 'ViewProduct',
        {/literal}
            {if !empty($currency)}
                currency: '{$currency|escape:"htmlall":"UTF-8"}',
            {/if}
        {literal}
        contents: [wph_product_obj],
    });
    {/literal}
</script>