{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Wirtualna Polska Media S.A.
* @copyright 2021-2022 Wirtualna Polska Media S.A.
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<script>
    {literal}
    !function(d,m,e,v,n,t,s){d['WphTrackObject'] = n;
        d[n] = window[n] || function() {(d[n].queue=d[n].queue||[]).push(arguments)},
            d[n].l = 1 * new Date(), t=m.createElement(e), s=m.getElementsByTagName(e)[0],
            t.async=1;t.src=v;s.parentNode.insertBefore(t,s)}(window,document,'script',
        'https://pixel.wp.pl/w/tr.js', 'wph');
    {/literal}
    wph('init', '{$pixel_id|escape:'javascript':'UTF-8'}', {
        plugin_name: "Prestashop{$pixel_versionPrestashop|escape:'javascript':'UTF-8'}",
        plugin_version: "{$pixel_versionPlugin|escape:'javascript':'UTF-8'}"
    });

    wph('track', 'ViewContent', { content_name: 'View' });

    {literal}

    window.wphGetCookie = function(name) {
        var match = document.cookie.match(new RegExp('(^| )' + name + '=([^;]+)'));
        if (match) return match[2];
    };

    window.wphDecodeObject = function (x) {
        return (decodeURI(x) !== decodeURIComponent(x));
    };

    var wphAddToCartLimit = 55;
    var wphCurrentATC = 0;

    window.wphRunAddToCart = function(r) {
        var wph_obj_cart = wphGetCookie('wp_add_to_cart');

        if( wph_obj_cart === undefined ) {

            if(r != 'reload' && wphCurrentATC != wphAddToCartLimit) {
                wphCurrentATC = wphCurrentATC + 1;
                setTimeout(wphRunAddToCart, 500);
            }

            return false;
        } else {
            setTimeout(wphRunAddToCart, 500);
        }

        if( wph_obj_cart !== undefined && wphDecodeObject( wph_obj_cart ) ) {

            wph_obj_cart = JSON.parse( decodeURIComponent( wph_obj_cart.replace(/\+/g, ' ') ) );

            wph('track', 'AddToCart', {
                currency: prestashop?.currency?.iso_code,
                contents: [wph_obj_cart]
            });

            document.cookie = "wp_add_to_cart= ; expires = Thu, 01 Jan 1970 00:00:00 GMT; path = /";
        }
    };

    window.wphBindEvents = function() {
        var wphQueryList = '{/literal}{$pixel_class|escape:'javascript':'UTF-8'}{literal}';

        const config = { attributes: true, childList: true, subtree: true };

        const callback = function(mutationsList, observer) {
            for(const mutation of mutationsList) {
                if (mutation.target.id && wphQueryList.search(mutation.target.id) != -1) {
                    setTimeout(wphRunAddToCart, 500);
                    return true;
                }
            }
        };

        const observer = new MutationObserver(callback);

        observer.observe(document.body, config);

    }

    window.wphCheckjQuery = function() {
        if( window.jQuery ) {
            wphBindEvents();
        } else {
            setTimeout(wphCheckjQuery, 500);
        }
    };

    window.onload = wphCheckjQuery;

    wphRunAddToCart('reload');
    {/literal}

</script>