{*
* 2007-2020 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@buy-addons.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
* @author    Wirtualna Polska Media S.A.
* @copyright 2021-2022 Wirtualna Polska Media S.A.
* @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*}
<script>
    {literal}
    var wph_obj = {
        content_type: 'Site',
        content_name: 'ProductList'
    };
    {/literal}

    {if !empty($category_name)}
        wph_obj.name = '{$category_name|escape:"htmlall":"UTF-8"}';
    {/if}

    {if !empty($currency)}
        wph_obj.currency = '{$currency|escape:"htmlall":"UTF-8"}';
    {/if}

    {literal}
    wph_obj.contents = [
        {/literal}{foreach from=$category_contents item=one_product}{literal}
        {
            id: "{/literal}{$one_product.id|escape:"javascript":'UTF-8'}{literal}",
            name: "{/literal}{$one_product.name|escape:"javascript":'UTF-8'}{literal}",
            price: {/literal}{$one_product.price|escape:"javascript":'UTF-8'}{literal},
            category: "{/literal}{$one_product.category|escape:"javascript":'UTF-8'}{literal}",
            quantity: {/literal}{$one_product.quantity|escape:"javascript":'UTF-8'}{literal},
            in_stock: {/literal}{$one_product.in_stock|escape:"javascript":'UTF-8'}{literal},
            {/literal}{if !empty($one_product.ean)}{literal}
            ean: "{/literal}{$one_product.ean|escape:"javascript":'UTF-8'}{literal}",
            {/literal}{/if}
            {if count($one_product.sizes)}{literal}
            sizes: [
                {/literal}{foreach from=$one_product.sizes item=one_size}{literal}
                "{/literal}{$one_size|escape:"javascript":'UTF-8'}{literal}",
                {/literal}{/foreach}{literal}
            ],
            {/literal}{/if}
            {if count($one_product.colours)}{literal}
            colours: [
                {/literal}{foreach from=$one_product.colours item=one_colour}{literal}
                "{/literal}{$one_colour|escape:"javascript":'UTF-8'}{literal}",
                {/literal}{/foreach}{literal}
            ],
            {/literal}{/if}{literal}

        },{/literal}{/foreach}
    ];

    {literal}
    wph('track', 'ViewContent', wph_obj);
    {/literal}
</script>